

insert into et_catalog_object_column_prop  (catalog_id, column_name, column_title_ui, column_heading_ui, domain_id_physical, domain_id_logical, domain_id_semantic)
values
-- 
(mdLookup_SysMDObject('et_callable_access'), 'callable_object',null,'on which access should be granted','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_access'),'usergroupname',null,'to which access to callable object is granted','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_callable_access'),'ind_active',null,'access of this object for this group', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_callable_object'),'callable_object',null,'a configuration entry that wraps a callable command which can be called by niota.','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_object'),'description','Callable','of the callable object (command, webservice, ...). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_callable_object'),'ind_active',null,null,'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_callable_object'),'callobject_type','Callable','of the callable object - SQL command, stored procedure, script, ...','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_callable_object'),'conn_name',null,'where callable object is located','ZPD_connection', null, 'ZSD_connection'),
(mdLookup_SysMDObject('et_callable_object'),'command','Callable','run this artefact. Previous to execution there is a parameter substitution. See: conf\callable_substitutions_help.txt','ZPD_commandstring','ZLD_largeblock','ZSD_commandstring'),
(mdLookup_SysMDObject('et_callable_object'),'callobject_category','Callable','of the callable object - Optional grouping of callable objects which belongs together logical','ZPD_categorystring',null,'ZSD_categorystring'),
(mdLookup_SysMDObject('et_callable_object'),'sortorder','Display','of the callable object when displayed on screen. The order is within an assignment to a catalog object','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_callable_object'),'ind_messaging','Messages','check to read message table after execution of object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_reload_grid','Table refresh','check to reload table table after execution of object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_seq','is sequence','Is it a sequence or a single callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'promptpage_type','Prompt','page / .php page that is called to prompt user input before executable is called','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_callable_object'),'icon_callable','Callable','file to be displayed on the user frontende','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_callable_object'),'ind_use_uca','use UCA','activation of user cummunication area between niota and callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_save_uca','save UCA','save user comm. area after call','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'uca','Callable Object','to pass values between backend program and user frontend','ZPD_ucastring','ZLD_largeblock','ZSD_uca'),
--
(mdLookup_SysMDObject('et_callable_seq'),'callable_object','Main Object','The first item of the sequence. A callable object with &apos;is sequence&apos; indicator','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_seq'),'callable_object_seq_member','Sequence Member','from &apos;callable objects&apos; table.','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_seq'),'sort_order','Execute','of the callable object in the sequence.','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_callable_seq'),'ind_active',null,null,'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_catalog_object'),'catalog_id',null,'is the unique number in niota for the managed database object','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object'),'conn_name',null,'where object is located','ZPD_connection',null,'ZSD_connection'),
(mdLookup_SysMDObject('et_catalog_object'),'object',null,'that is managed with niota','ZPD_objectname','ZLD_tinyblock','ZSD_managedobject'),
(mdLookup_SysMDObject('et_catalog_object'),'description','Object','of the catalog object (table, view). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object'),'date_activation','Activation','activation of this configuration (logically)',null,null,'ZSD_dateof'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_active',null,'activate this configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object'),'objectcategory','Object','to group objects on own demand. Can be used in quick access drop down box','ZPD_categorystring',null,'ZSD_categorystring'),
(mdLookup_SysMDObject('et_catalog_object'),'format_file_prefix','File or Database','to format object very generic based on column name only','ZPD_collection',null,'ZSD_collection'),
(mdLookup_SysMDObject('et_catalog_object'),'username_owner','Owner','that is responsible for content of this object. Data owner','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_catalog_object'),'usergroupname_deputy','Owner Deputy','that acts as deputy for data owner. Will be informed via major changes.','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_nolog_upload','suppress upload log','to suppress logging in case of upload (usefull for large tables)','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_01','01','- #01 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_02','02','- #02 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_03','03','- #03 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_04','04','- #04 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_05','05','- #05 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_06','06','- #06 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_07','07','- #07 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_08','08','- #08 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_09','09','- #09 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_10','10','- #10 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
--
(mdLookup_SysMDObject('et_catalog_object_access'),'usergroupname','Access','to which the access rights are granted to','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_catalog_object_access'),'catalog_id',null,'on which access rights are granted','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_access'),'instance_name',null,'on which access rights are granted','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_ins','add','insert new rows allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upd','edit','edit rows allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_del','delete','delete allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_import','import','import via EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_export','export','export to EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upd_partial','partial update','inactive', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upload_partial','partial import','partial import via EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_hidden','hidden','hidden property in quick access drop down', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_catalog_object_callable'),'catalog_id',null,'to which a callable object is assigned','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'callable_object',null,'that is assigned to the catalog object','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'description','Callable Object','for assignment','ZPD_description','ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'ind_active',null,'binding','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'binding_level','Binding','Binding  On which level is the callable object bind to catalog object (table/vies). Row/Record-level, Table-level','ZPD_typeN',null,'ZSD_level'),
--
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'catalog_id',null,'Catalog Object ID where the configured column properties will apply','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'description','Column','of this column','ZPD_description','ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_active',null,'column properties','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name','for Column','configuration which will be applied to this column','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_lookup_import_check','Lookup at import','apply lookup checks on import via EXCEL','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'constraint_name','for Column','configuration which will be applied to this column','ZPD_constraintID',null,'ZSD_constraint'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_constraint_import_check','Constraint at import','apply constraints on import via EXCEL','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ordinal_position_pkey','in primary key','of this column in the (logical) primary key of the object. MUST be set on views','ZPD_ordinalNBR',null,'ZSD_ordinalpos'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name_extended','extended','configuration in case of cascading lookup','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name_extended_lookup','Filter extended','that filters the relationship table for extended lookup','ZPD_columnname',null,'ZPD_columnname'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_use_extended_lookup','extended lookup','checkbox to toggle usage of extended lookup config','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_add_null','NULL selection','add/allow nulls to lookup drop down','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'datatype','DB column', 'of column', null, null, 'ZSD_datatype'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'metatype','UI column','of column', 'ZPD_typeX', null, 'ZSD_datatype'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_nullable','Column is nullable','of column','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_mark'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_len','column',' of column','ZPD_smallNBR2', null, 'ZSD_length'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_autoseq','autosequence','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_mark'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_volatile','volatile','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_required','required','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_read_only','read only','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_hidden','hidden','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_editable_hidden','hidden editable','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_physical','physical','that defines physical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_logical','logical','that defines logical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_semantic','semantic','that defines semantic attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_title_ui','Column - Suffix','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_heading_ui','Column - Suffix','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'colpos_form','Column Axis','value of columnindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'rowpos_form','Row Axis','value of rowindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),

--
(mdLookup_SysMDObject('et_catalog_object_instance'),'catalog_id',null,'for which an instance is defined','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'instance_name',null,'to be defined. An Instance is a specific representation of a catalog object in display properties and filter','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'description','Instance','of the catalog object (table, view). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'projection_list','Columnlist','list of columns used in SQL generation','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_projection_list','Columnlist','mark to activate usage of column list', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'read_only_list','Read only','to set to read only','ZPD_commandstring','ZLD_commandblock','ZSD_columnlist'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_read_only_list','Read Only','of read only list', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectfilter','for Filter (where)','Where conditions - without WHERE clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectfilter','Filter','of filter clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectjoin','for Join','join conditions - with JOIN clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectjoin','Join','mark to activate usage of join condition', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectunion','for Union','union conditions - without UNION clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectunion','Union','mark to activate usage of union clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectgroupby','for Group by','group by clause - without keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectgroupby','Group by','mark to activate usage of group by clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectorder','for Order by','order by clause - without keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectorder','Order by','mark to activate usage of order by clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_lookup','Lookup','this instance as lookup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_filter','Filter','this instance as filter table in advanced filter setting', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_grid','Grid','this instance as standard grid','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_detail','Detail','this instance as detail in master detail','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
--
(mdLookup_SysMDObject('et_connection'),'conn_name',null, 'to be configured','ZPD_connection', null, 'ZSD_connection'),
(mdLookup_SysMDObject('et_connection'),'description','Connection','of connection', 'ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_connection'),'conn_name_msg','Messages','where message table is located','ZPD_connection', null, 'ZSD_DBconnection'),
(mdLookup_SysMDObject('et_connection'),'conn_type',null,null,'ZPD_typeN', null, 'ZSD_connectiontype'),
--
(mdLookup_SysMDObject('et_constraint'),'constraint_name',null,'name of a value check. Value checks are applied during editing a table','ZPD_constraintID',null,'ZSD_constraint'),
(mdLookup_SysMDObject('et_constraint'),'description',null,'of constraint. Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_constraint'),'ind_active',null,'constraint definition','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_constraint'),'operand_1','Operand 1','Operand 1 for data check - Value that is checked with operator against the column where this constraint will be assigned',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'operand_2','Operand 2','Operand 2 for data check - Value that is checked with operator against the column where this constraint will be assigned',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'column_type','Column<br>datatype','Basis datatype of the column - used for some internal constraint - e.g. numeric checks',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'operation','Operation','Operation used for the constraint value check',null,null,null),
--
(mdLookup_SysMDObject('et_format_collection_column'),'collection_id',null,'on which properties are configured','ZPD_collection',null,'ZSD_collection'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_format_collection_column'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_collection_column'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_title_ui','Column','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_heading_ui','Column','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
--
(mdLookup_SysMDObject('et_format_domain_logical'),'domain_id_logical','Logical','that defines logical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_logical'),'description','Logical Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_logical'),'edittype',null,'of the generated edit form column','ZPD_edittype', null, 'ZSD_edittype'),
(mdLookup_SysMDObject('et_format_domain_logical'),'param_edittype','Edittype','column to be appended to the domain heading setting','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
(mdLookup_SysMDObject('et_format_domain_logical'),'textarea_rows','Rows','column to be appended to the domain heading setting','ZPD_smallNBR2', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_domain_logical'),'textarea_cols','Columns','column to be appended to the domain heading setting','ZPD_smallNBR2', null, 'ZSD_editsize'),
--
(mdLookup_SysMDObject('et_format_domain_physical'),'domain_id_physical','Physical','that defines physical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_physical'),'description','Pysical Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_physical'),'editsize','on screen','of the generated edit form column','ZPD_smallNBR3', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_domain_physical'),'editmaxlength','to enter','column to be appended to the domain heading setting','ZPD_smallNBR5', null, 'ZSD_editsize'),
--
(mdLookup_SysMDObject('et_format_domain_semantic'),'domain_id_semantic','Semantic','that defines semantic/textual attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'description','Semantic Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'column_title_ui','Column','column to used as the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'column_heading_ui','Column','column to be used as the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'colvalue_default','Default','used as the default value in case of add new record','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
--
(mdLookup_SysMDObject('et_format_object'),'catalog_id',null,'for which extended format is valid','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_format_object'),'instance_name',null,'for which extended format is valid','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_format_object'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_object'),'grid_caption_ui','on Screen',null, 'ZPD_caption', 'ZLD_description', 'ZSD_caption'),
(mdLookup_SysMDObject('et_format_object'),'grid_caption_suffix_ui','Suffix on Screen','suffix', 'ZPD_caption', 'ZLD_description', 'ZSD_caption'),
(mdLookup_SysMDObject('et_format_object'),'pagesize','Nbr. Records','number of records to be displayed','ZPD_smallNBR3', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_object'),'form_width','Window Width','number of pixels for edit form','ZPD_smallNBR5', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_object'),'ind_rownumbers','Rownumbers',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object'),'ind_advanced_search','advanced Search',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object'),'ind_multiselect','Multiselect',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
--
(mdLookup_SysMDObject('et_format_object_column'),'catalog_id',null,'for which extended format is valid','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_format_object_column'),'instance_name',null,'for which extended format is valid','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_format_object_column'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_required','required','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_read_only','read only','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_hidden','hidden','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_editable_hidden','hidden editable','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_format_object_column'),'column_title_ui','Column - Suffix','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_object_column'),'column_heading_ui','Column - Suffix','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_format_object_column'),'colpos_form','Column Axis','value of columnindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
(mdLookup_SysMDObject('et_format_object_column'),'rowpos_form','Row Axis','value of rowindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
--
(mdLookup_SysMDObject('et_logging'),'conn_name','to be logged','for which logging should be activated.','ZPD_connection',null,'ZSD_DBconnection'),
(mdLookup_SysMDObject('et_logging'),'ind_active_logfile','Log to file','write log into file','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_logging'),'ind_active_logdb','Log to table','write log into DB table. Details for logging must be set in the callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_logging'),'filename_log','Logfile','where logdata is written on server','ZPD_filename',null,'ZSD_filename'),
(mdLookup_SysMDObject('et_logging'),'callable_object','for logging','used for logging into DB table. Symbolic name of the logging SQL command or the logging stored procedure.','ZPD_callable',null,'ZSD_callable'),
--
(mdLookup_SysMDObject('et_lookup'),'lookup_name',null,'of a table reference. References / lookups are displayed as drop down list when editing a table','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_lookup'),'description','Lookup','of lookup configuration. Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_lookup'),'ind_active',null,'lookup defintion','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_lookup'),'catalog_id_lookup','Lookup','that is displayed for lookup. Definition of a lookup object can be done by standard object definition','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_lookup'),'instance_name_lookup','Lookup','that is displayed for lookup. Definition of a lookup instance can be done by standard instance definition','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_lookup'),'lookup_type','Lookup','Lookup - can be standard lookup or cascading - for details check drop down list','ZPD_typeN',null,'ZSD_type'),
--
(mdLookup_SysMDObject('et_metadb_object'),'object',null,'that is part of meta db','ZPD_objectname','ZLD_tinyblock','ZSD_managedobject'),
(mdLookup_SysMDObject('et_metadb_object'),'description','Object','of the meta db object (table, view). Used for grid caption','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_metadb_object'),'ind_active',null,'activate this configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_metadb_object'),'er_level','Depth in Model','nesting level in data model','ZPD_checkbox', null, 'ZSD_level'),
(mdLookup_SysMDObject('et_metadb_object'),'sortorder','Import Export',' used for in import export script for deployment','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_metadb_object'),'ind_deploy','Deploy','of this meta db object data','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_metadb_object'),'objabbrev','Object','this meta db object - 5 character abbrevation',null, null, 'ZSD_codeof'),
(mdLookup_SysMDObject('et_metadb_object'),'catalog_id',null,'is the unique number in niota for the managed database object','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_metadb_object'),'conn_name',null,'where object is located','ZPD_connection',null,'ZSD_connection'),
--
(mdLookup_SysMDObject('et_table_link'),'catalog_id_master','Master','where configuration starts','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link'),'instance_name_master','Master','where configuration starts','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link'),'logical_link','Master-Details','Catalog object instance where configuration starts','ZPD_loglink',null,'ZSD_loglink'),
(mdLookup_SysMDObject('et_table_link'),'catalog_id_detail','Detail','config is linked to','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link'),'instance_name_detail','Detail','that is a config to master','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link'),'linktype','Link','logical link - master-detail or data-advanced filter','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_table_link'),'ind_logical_link_default','as default','to set a advanced filter configuration as default filter','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_table_link'),'grid_location_detail','Detail<br>grid location','Location in case of master detail where grid is on screen','ZPD_digit',null,'ZDS_gridlocation'),
(mdLookup_SysMDObject('et_table_link'),'icon_link','Master-Detail link','that contains the icon for this configuration','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_table_link'),'description','of Relationship','of link configuration. Used for tooltip - mouse over on icon','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('et_table_link_detail'),'catalog_id_master','Master','where configuration starts','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link_detail'),'instance_name_master','Master','where configuration starts','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link_detail'),'logical_link','Master-Details','Catalog object instance where configuration starts','ZPD_loglink',null,'ZSD_loglink'),
(mdLookup_SysMDObject('et_table_link_detail'),'column_name_master','of Master Table','used to link between master-detail/data filter instances','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_table_link_detail'),'column_name_detail','in Detail Table','used to link between master-detail/data filter instances','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_table_link_detail'),'operation','Operator','Comparison operation  - compare/filter Operation',null,null,null),
(mdLookup_SysMDObject('et_table_link_detail'),'sortorder','Sortorder','Sort order - used for generation order by clause in case of advance filter',null,null,null),
--
(mdLookup_SysMDObject('et_transaction'),'transaction_code',null,'Name of the transaction - group of predefined properties of a catalog object (table/view).','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction'),'description','Transaction','of the transaction','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_transaction'),'ind_active',null,'transaction definition','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_transaction'),'targetpage','Targetpage','Target page for the transaction for user interaction',null,null,null),
(mdLookup_SysMDObject('et_transaction'),'param_set','Parameter<br>Group','Parametergroup to configure this transaction',null,null,null),
--
(mdLookup_SysMDObject('et_transaction_access'),'transaction_code',null,'on which access should be granted','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_access'),'usergroupname','Access','to which access should be granted to use this transaction','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_transaction_access'),'ind_active','use','access grants for this usergroup / transaction','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
--
(mdLookup_SysMDObject('et_transaction_menu'),'menu_id',null,'Unique ID of the entry in the menu tree. Other menu items can refer to this as a parent menu id.' ,'ZPD_menu',null,'ZSD_menu'),
(mdLookup_SysMDObject('et_transaction_menu'),'transaction_code',null,'assigned to this menu entry','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_menu'),'menu_label','Menu Item','to display','ZPD_label',null,'ZSD_label'),
(mdLookup_SysMDObject('et_transaction_menu'),'description','Menu Item','of menu entry - not displayed','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_transaction_menu'),'ind_active',null,'menu configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_transaction_menu'),'menu_id_parent','Parent','of the parent entry','ZPD_menu',null,'ZSD_menu'),
(mdLookup_SysMDObject('et_transaction_menu'),'icon_menu','Menue Item','that contains the icon for this configuration','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_transaction_menu'),'sortorder','Display','display when multiple menu items under one nodes','ZPD_sortorder',null,'ZSD_sortorder'),
--
(mdLookup_SysMDObject('et_transaction_parameter_set'),'transaction_code',null,'for which this set of parameters is valid','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_set','Parameter<br>Group','Name / Code of the transaction for which this set of parameters is valid',null,null,null),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_name','Parameter<br>Name','Parametername - logical name of the configuration parameter - predefine list',null,null,null),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_value','Parameter<br>Value','Parametervalue - value of the configuration parameter',null,null,null),
--
(mdLookup_SysMDObject('et_user'),'username',null,'of user in niota application','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user'),'description','User','of user - used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_user'),'ind_active',null,'user configuration','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
(mdLookup_SysMDObject('et_user'),'password','niota','for native niota sign-in','ZPD_password',null,'ZSD_password'),
(mdLookup_SysMDObject('et_user'),'email',null,'of user - used in a lot of backend procedures - should be provided','ZPD_email',null,'ZSD_email'),
(mdLookup_SysMDObject('et_user'),'firstname',null,'of user','ZPD_humanname','ZLD_tinyblock','ZSD_firstname'),
(mdLookup_SysMDObject('et_user'),'lastname',null,'of user','ZPD_humanname','ZLD_tinyblock','ZSD_lastname'),
(mdLookup_SysMDObject('et_user'),'phone','Phone','Phonenumber of user','ZPD_phone',null,'ZSD_phone'),
(mdLookup_SysMDObject('et_user'),'ind_active_ldap','LDAP authentication','LDAP authentification - if configured correctly','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('et_user'),'username_ldap','LDAP','in LDAP system if used and different from main user ID','ZPD_userID',null,'ZSD_user'),
(mdLookup_SysMDObject('et_user'),'ind_is_admin','Administrator','administrator features for this user','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('et_user'),'lang_grid','Grid Area','for grid edit pages','ZPD_language',null,'ZSD_language'),
--
(mdLookup_SysMDObject('et_user_comm_area'),'username',null,'this communication area is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_comm_area'),'appcode',null,'this communication area is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('et_user_comm_area'),'id_session','Comm. Area Entry','that generated the last comm. area entry','ZPD_session',null,'ZSD_session'),
(mdLookup_SysMDObject('et_user_comm_area'),'guid_msg','Message','last message in communication entry','ZPD_GUID',null,'ZSD_GUID'),
(mdLookup_SysMDObject('et_user_comm_area'),'lang_grid',null,'for communication area values','ZPD_language',null,'ZSD_language'),
(mdLookup_SysMDObject('et_user_comm_area'),'uca','User Communication<br>Area','Communication area data - set on last usage of UCA','ZPD_ucastring','ZLD_largeblock','ZSD_uca'),
--
(mdLookup_SysMDObject('et_user_group'),'usergroupname',null,'technical name of usergroup. A usergroup is a unit of different users. Usergroups must not be nested','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_user_group'),'description','User Group','of user group - used for lookup','ZPD_description', 'ZLD_tinylock', 'ZSD_description'),
(mdLookup_SysMDObject('et_user_group'),'ind_active',null,'user group configuration','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
(mdLookup_SysMDObject('et_user_group'),'usergroup_type','User Group','of the user group - systemgroup, own (single-)user group, configurable group','ZPD_typeN',null,'ZSD_typeN'),
--
(mdLookup_SysMDObject('et_user_group_member'),'usergroupname',null,'to add a member. Usergroups must not be nested','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_user_group_member'),'username',null,'to grant membership','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_group_member'),'description','Membership','of users membership in this group - used for lookup','ZPD_description', 'ZLD_tinylock', 'ZSD_description'),
(mdLookup_SysMDObject('et_user_group_member'),'ind_active','Membership','membership of this user in this user group','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
--
(mdLookup_SysMDObject('et_user_parameter'),'param_id','User System Param.','of system parameter - set by system','ZPD_bigNBR11',null,'ZSD_autosequence'),
(mdLookup_SysMDObject('et_user_parameter'),'username',null,'this parameter is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_parameter'),'param_name','User System Param.','of user system parameter - set by system','ZPD_paramlong','ZLD_wideblock','ZSD_config'),
(mdLookup_SysMDObject('et_user_parameter'),'param_value','User Parameter','user system parameter - set by system during editing a table. May be changed. Caution!','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_01','01','- first filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_02','02','- second filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_03','03','- third filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_04','04','- fourth filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_05','05','- fifth filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
--
(mdLookup_SysMDObject('etx_catalog_object_config'),'appcode_cfg',null,'for which this system configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'catalog_id',null,'for which a config value should be configured','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'cfg_id','Object Level','of catalog object level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'cfg_value','Object ID Level','of catalog object level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'description','System Config.','of this system configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('etx_message_text'),'appcode_msg',null,'for which this message configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_message_text'),'msg_id',null,'of this message config entry','ZPD_messageID',null,'ZSD_messageID'),
(mdLookup_SysMDObject('etx_message_text'),'lang_msg','Message','of this message config entry','ZPD_language',null,'ZSD_language'),
(mdLookup_SysMDObject('etx_message_text'),'type_msg','Message','of this specific message ERR/INF/WRN ','ZPD_typeXXX',null,'ZSD_typeXXX'),
(mdLookup_SysMDObject('etx_message_text'),'ind_stop_msg','Stop Message','property that stopps execution when message is triggered','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('etx_message_text'),'text_msg','Message','this specifice message','ZPD_messagestring','ZLD_mediumblock','ZSD_text'),
--
(mdLookup_SysMDObject('etx_sequence'),'appcode_seq',null,'for which this sequence configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_sequence'),'seq_id','Sequence<br>ID','Unique ID for this sequence definition','ZPD_config',null,null),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_increment','Increment','by which the sequence is incremented in case an element is used','ZPD_smallNBR5',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_min','Start of Sequence','Minimum value/start value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_max','End of Sequence','Maximum value/end value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_cur','Current of Sequence','Current value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'ind_cycle','cycle','sequence definition to cyclyc','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
--
(mdLookup_SysMDObject('etx_system_config'),'appcode_cfg',null,'for which this system configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_system_config'),'cfg_id','System Level','of system level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_system_config'),'cfg_value','System Level','of system level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_system_config'),'description','System Config.','of this system configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('etx_user_config'),'appcode_cfg',null,'for which this configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_user_config'),'username',null,'for which this configuration entry is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('etx_user_config'),'cfg_id','User Level','of user level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_user_config'),'cfg_value','User Level','of user level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_user_config'),'description','User Config.','of this user configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description')
--
as loadval
on DUPLICATE KEY UPDATE
 column_title_ui = loadval.column_title_ui
,column_heading_ui = loadval.column_heading_ui
,domain_id_physical = loadval.domain_id_physical
,domain_id_logical = loadval.domain_id_logical
,domain_id_semantic = loadval.domain_id_semantic
;